/**
 *  Copyright 2018 Avaya Inc. All Rights Reserved.
 *
 * Usage of this source is bound to the terms described in
 * licences/License.txt
 *
 * Avaya - Confidential & Proprietary. Use pursuant to your signed agreement or
 * Avaya Policy
 * 
 * Defines configuraiton parameters for chat.
 */

// the WebSocket is globally accessible - there should only ever be one on the page?
var webSocket;


/**
 * Defines keywords for various widget types.
 */
var widgetConfig ={
    radio :"radio",
    button : "button",
    selector : "selector",
    click : "click"
};

var chatConfig = {

    totalNumberOfRetries : 0,
    maxNumberOfRetries : 200,
    retryInterval : 3000,
    maxWebOnHoldMessages : 50,

    // If set to true, if the Websocket connection fails we will not attempt to re-establish the session
    dontRetryConnection : false,
    reconnectionTimeout : null,
    previouslyConnected : false,
    resetTimer : 5000,

    // message types
    messageTypeAck : 'acknowledgement',
    messageTypeError : 'error',
    messageTypeNotification : 'notification',

    // notification messages are further broken down
    jsonMethodRequestChat : 'requestChat',
    jsonMethodRouteCancel : 'routeCancel',
    jsonMethodRequestNewParticipant : 'newParticipant',
    jsonMethodRequestIsTyping : 'isTyping',
    jsonMethodRequestNewMessage : 'newMessage',
    jsonMethodRequestCloseConversation : 'closeConversation',
    jsonMethodRequestParticipantLeave : 'participantLeave',
    jsonMethodRequestNewPushMessage : 'newPushPageMessage',
    jsonMethodRequestNewCoBrowseSessionKeyMessage : 'newCoBrowseSessionKeyMessage',
    jsonMethodPing : 'pong',
    jsonMethodFileTransfer : 'newAgentFileTransfer',
    jsonMethodWebOnHoldMessage : 'webOnHoldMessage',
    
    openingChatText: "Sending Login Details",
    reloadingPageText : "Opening chat after page refresh",
    chatOpenedText : 'Login request received and approved',
    invalidEmailAddressText : 'There are invalid characters in your email address. You will not be able to receive a transcript',
    successfulReconnectionText : 'Successfully reconnected',
    closeRequestText : 'Close request sent',
    connectionClosedText : "Connection closed, chat has ended",
    connectionErrorText : 'A connection error has occurred. Check the console for more details',
    closedForMaintenanceText : 'Contact centre is shutting down for maintenance. Please try again later',
    attemptingToReconnectText : 'Attempting to reconnect...',
    unableToReconnectText : 'Unable to reconnect, chat has ended',
    panelCloseText : 'The panel will close automatically in {0} seconds',
    errorOccurredText: 'Error code {0} occurred ({1})',
    unknownWidgetText: "That widget type is not available",

    // placeholder for new message. Format is displayName (timestamp): messageText
    newMessageText : '{0} ({1}): {2}',
    
    agentJoinedMessage : 'An agent has joined the chat',
    agentLeftMessage : 'An agent has left the chat',
    routeCancelText: 'No suitable agents could be found',

    // placeholder for file transfer notifications. {0} is agent's name, {1} is the file name, {2} is the timestamp. {3} is the URL
    fileTransferMessageText : '{0} transferred a file ({1}) at {2}. Please visit {3} to download it',

    transferNotificationText : 'Transferring to another service, please remain in the chat',
    requeueNotificationText : 'Re-queuing chat, please remain in the chat',
    chatbotTransferNotification : 'Transferring to a live agent, please remain in the chat',
    transferToUserText : "Transferring to another agent, please remain in the chat",

    // placeholder for page push messages. {0} represents agent display name, {1} is the timestamp
    pagePushMessageTextAgent : 'Agent sent the following link: ',
    pagePushMessageTextBot : '',
    coBrowseMessageText : '{0} initiated a Co-Browsing session at ({1})',
    coBrowseSessionStartedText : "Co-Browsing session initiated",
    coBrowseSessionFinishedText : "Co-Browsing session finished",

    notifyOfObserve : false,
    notifyOfCoach : false,
    notifyOfBarge : false,

    serverWebOnHold: false,

    // if set to true, the chatbot will not announce its arrival/departure
    suppressChatbotPresence : false,

    // how frequently the pings are sent
    pingTimer : 5000,

    typingTimeout : 10000,
    agentTypingTimeout : 3000,

    // default username for if the customer doesn't enter a name.
    defaultUsername : 'Customer',

    // CSS classes that distinguish customer from agent messages
    writeResponseClassResponse : 'response',
    writeResponseClassSent : 'sent',
    writeResponseClassSystem : 'system',
    writeResponseClassDate : 'date',
    writeResponseClassAgentDate : 'agentDate',
    writeResponseClassChatbot : 'chatbot',

    // links to various images
    agentImage : 'images/agent.png',
    agentTypingImage : 'images/agent_typing.png',
    supervisorImage : 'images/supervisor.png',
    supervisorTypingImage : 'images/supervisor_typing.png',

    // lease time in Context Store, measured in hours (if set to 0, lease time will be retrieved from ORC attributes)
    leaseTime : 0,
    
    requireFirstName: true,
    requireLastName: true,
    requireEmail: true,
    requirePhone: true,
   
    // how long should we hold session data after closing/leaving the page
    // this should mtch the refresh/idle timeout in the Administration Utility
    refreshTimeoutSeconds: 180,

    setLeaseTime : function(newLeaseTime) {
        'use strict';
        if (typeof (newLeaseTime) !== 'number' || newLeaseTime > 96) {
            console.warn("Invalid lease time! Resetting to default");
            newLeaseTime = 0;
        }
        chatConfig.leaseTime = newLeaseTime;
    },

    /**
     * Utility function to request the EWT manually. Acts as a wrapper for the config panel.
     */
    requestEwt : function() {
        'use strict';
        ewt.requestEwt();
    },

    showChatPanel : function() {
        'use strict';
        chatUI.showChatPanel();
    },

    initCobrowse : function() {
        'use strict';
        if (window.coBrowse !== undefined) {
            coBrowse.init();
        }
    }

};
